/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrookRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private final List<CrookRecipe> recipeList = new ArrayList<CrookRecipe>();
    @Nonnull
    private final Map<ItemLike, List<CrookRecipe>> recipeListByItemCache = new HashMap<ItemLike, List<CrookRecipe>>();

    public boolean isCrookable(@Nonnull ItemLike block) {
        return !this.getDrops(block).isEmpty();
    }

    @Nonnull
    public List<CrookRecipe> getDrops(@Nonnull ItemLike block) {
        return this.recipeListByItemCache.computeIfAbsent(block, k -> {
            ItemStack itemStack = new ItemStack(block);
            return this.recipeList.stream().filter(crookRecipe -> crookRecipe.getInput().test(itemStack)).collect(Collectors.toList());
        });
    }

    public void setRecipes(@Nonnull List<CrookRecipe> recipes) {
        logger.debug("Crook Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.recipeListByItemCache.clear();
    }

    @Nonnull
    public List<CrookRecipe> getRecipeList() {
        return this.recipeList.stream().flatMap(crookRecipe -> {
            if (crookRecipe.getOutput().size() <= 21) {
                return Stream.of(crookRecipe);
            }
            List partitions = Lists.partition(crookRecipe.getOutput(), (int)21);
            return IntStream.range(0, partitions.size()).mapToObj(i -> {
                ResourceLocation crookRecipeId = crookRecipe.m_6423_();
                ResourceLocation newId = new ResourceLocation(crookRecipeId.m_135827_(), crookRecipeId.m_135815_() + i);
                return new CrookRecipe(newId, crookRecipe.getInput(), (List)partitions.get(i));
            });
        }).collect(Collectors.toList());
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.recipeListByItemCache.clear();
    }
}

